/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.rest.okhttp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Pair;
import net.linksfield.cube.partnersdk.rest.HttpFunction;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpResponse;
import net.linksfield.cube.partnersdk.rest.StatusCode;
import net.linksfield.cube.partnersdk.utils.GuavaUtils;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpTemplate
implements HttpFunction {
    private static final Logger log = LoggerFactory.getLogger(OkHttpTemplate.class);
    private OkHttpClient okHttpClient;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    private OkHttpClient initOkHttpClient() {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        return okHttpClient;
    }

    public OkHttpTemplate() {
        log.debug("[Cube] The SDK will use OkHttp as the Http client implementation");
        this.okHttpClient = this.initOkHttpClient();
    }

    @Override
    public HttpResponse get(HttpRequest request) {
        Request.Builder requestBuilder = new Request.Builder().get();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)request.getUrl()).newBuilder();
        request.getQueryParams().forEach((key, value) -> urlBuilder.addQueryParameter(key, value));
        Request okRequest = this.buildRequest(requestBuilder, urlBuilder.build(), request);
        return this.execute(okRequest);
    }

    @Override
    public HttpResponse post(HttpRequest request) {
        return this.postPutDelete(request, arg_0 -> ((Request.Builder)new Request.Builder()).post(arg_0));
    }

    @Override
    public HttpResponse put(HttpRequest request) {
        return this.postPutDelete(request, arg_0 -> ((Request.Builder)new Request.Builder()).put(arg_0));
    }

    @Override
    public HttpResponse delete(HttpRequest request) {
        return this.postPutDelete(request, arg_0 -> ((Request.Builder)new Request.Builder()).delete(arg_0));
    }

    private HttpResponse postPutDelete(HttpRequest request, Function<RequestBody, Request.Builder> builderFunction) {
        Request.Builder requestBuilder;
        String contentType = GuavaUtils.getMultimapFirst(request.getHeaders(), "Content-Type");
        if ("x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
            requestBuilder = new Request.Builder().get();
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)request.getUrl()).newBuilder();
            request.getQueryParams().forEach((key, value) -> urlBuilder.addQueryParameter(key, value));
        } else {
            RequestBody requestBody = RequestBody.create((String)request.getBodyString(), (MediaType)JSON);
            requestBuilder = builderFunction.apply(requestBody);
        }
        Request okRequest = this.buildRequest(requestBuilder, HttpUrl.parse((String)request.getUrl()), request);
        return this.execute(okRequest);
    }

    private Request buildRequest(Request.Builder requestBuilder, HttpUrl url, HttpRequest request) {
        request.getHeaders().forEach((key, value) -> requestBuilder.addHeader(key, value));
        Request okRequest = requestBuilder.url(url).build();
        return okRequest;
    }

    public HttpResponse execute(Request okRequest) {
        try {
            Response okResponse = this.okHttpClient.newCall(okRequest).execute();
            HttpResponse response = new HttpResponse();
            StatusCode statusCode = new StatusCode();
            statusCode.setStatusCode(okResponse.code());
            response.setHttpStatus(statusCode);
            HashMultimap headers = HashMultimap.create();
            okResponse.headers().forEach(arg_0 -> OkHttpTemplate.lambda$execute$3((Multimap)headers, arg_0));
            response.setHeaders((Multimap<String, String>)headers);
            response.setBodyResource(ByteSource.wrap((byte[])okResponse.body().bytes()));
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        log.debug("now connection manager is okhttp, close and shutdown connection pool");
    }

    private static /* synthetic */ void lambda$execute$3(Multimap headers, Pair pair) {
        headers.put((Object)((String)pair.getFirst()), (Object)((String)pair.getSecond()));
    }
}

