/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.rest.httpclient5;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import net.linksfield.cube.partnersdk.rest.HttpFunction;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpResponse;
import net.linksfield.cube.partnersdk.rest.StatusCode;
import net.linksfield.cube.partnersdk.rest.httpclient5.HttpClient5Configuration;
import net.linksfield.cube.partnersdk.utils.GuavaUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient5Template
implements HttpFunction {
    private static final Logger log = LoggerFactory.getLogger(HttpClient5Template.class);
    private HttpClient5Configuration configuration;

    public HttpClient5Template(HttpClient5Configuration configuration) {
        log.debug("[Cube] The SDK will use HttpClient5 as the Http client implementation");
        this.configuration = configuration;
    }

    @Override
    public HttpResponse get(HttpRequest request) {
        try {
            URIBuilder uriBuilder = new URIBuilder(request.getUrl());
            request.getQueryParams().forEach((key, value) -> uriBuilder.addParameter(key, value));
            HttpGet get = new HttpGet(uriBuilder.build());
            this.addHeaders((HttpUriRequestBase)get, request);
            return this.execute((HttpUriRequestBase)get);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HttpResponse post(HttpRequest request) {
        return this.postPutDelete(request);
    }

    @Override
    public HttpResponse put(HttpRequest request) {
        return this.postPutDelete(request);
    }

    @Override
    public HttpResponse delete(HttpRequest request) {
        return this.postPutDelete(request);
    }

    private HttpResponse postPutDelete(HttpRequest request) {
        try {
            URIBuilder uriBuilder = new URIBuilder(request.getUrl());
            String contentType = GuavaUtils.getMultimapFirst(request.getHeaders(), "Content-Type");
            if ("x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                request.getQueryParams().forEach((key, value) -> uriBuilder.addParameter(key, value));
            }
            HttpUriRequestBase post = new HttpUriRequestBase(request.getMethod().name(), uriBuilder.build());
            this.addHeaders(post, request);
            if ("application/json".equalsIgnoreCase(contentType)) {
                this.addBody(post, request);
            }
            return this.execute(post);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void addHeaders(HttpUriRequestBase httpRequest, HttpRequest requestWrapper) {
        requestWrapper.getHeaders().forEach((key, value) -> httpRequest.addHeader(key, value));
    }

    private void addBody(HttpUriRequestBase httpRequest, HttpRequest requestWrapper) {
        httpRequest.setEntity((HttpEntity)new StringEntity(requestWrapper.getBodyString(), ContentType.APPLICATION_JSON));
    }

    private HttpResponse execute(HttpUriRequestBase httpRequest) {
        CloseableHttpClient httpClient = this.configuration.getClient();
        try {
            HttpResponse httpResponse = (HttpResponse)httpClient.execute((ClassicHttpRequest)httpRequest, (HttpClientResponseHandler)new ResponseHandler());
            return httpResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        log.debug("now connection manager is httpclient5, close and shutdown connection pool");
        this.configuration.close();
    }

    private class ResponseHandler
    implements HttpClientResponseHandler<HttpResponse> {
        private ResponseHandler() {
        }

        public HttpResponse handleResponse(ClassicHttpResponse classicHttpResponse) throws HttpException, IOException {
            HttpResponse response = new HttpResponse();
            StatusCode statusCode = new StatusCode();
            statusCode.setStatusCode(classicHttpResponse.getCode());
            statusCode.setReasonPhrase(classicHttpResponse.getReasonPhrase());
            response.setHttpStatus(statusCode);
            HashMultimap headers = HashMultimap.create();
            for (Header header : classicHttpResponse.getHeaders()) {
                headers.put((Object)header.getName(), (Object)header.getValue());
            }
            response.setHeaders((Multimap<String, String>)headers);
            try (InputStream inputStream = classicHttpResponse.getEntity().getContent();){
                byte[] bodyBytes = ByteStreams.toByteArray((InputStream)inputStream);
                response.setBodyResource(ByteSource.wrap((byte[])bodyBytes));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedOperationException e) {
                throw new RuntimeException(e);
            }
            return response;
        }
    }
}

