/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.rest.httpclient5;

import java.io.Closeable;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpClient5Configuration
implements Closeable {
    private HttpClientConnectionManager connectionManager = this.createPoolingConnectionFactory();
    private RequestConfig defaultRequestConfig = this.createRequestConfig();

    public CloseableHttpClient getClient() {
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager(this.connectionManager).setDefaultRequestConfig(this.defaultRequestConfig).build();
        return httpclient;
    }

    public HttpClientConnectionManager createPoolingConnectionFactory() {
        SSLContext sslContext = SSLContexts.createSystemDefault();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.ofMinutes((long)5L));
        connManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        connManager.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)30L)).setSocketTimeout(Timeout.ofSeconds((long)30L)).setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).setTimeToLive(TimeValue.ofHours((long)1L)).build());
        connManager.setMaxTotal(10);
        connManager.setDefaultMaxPerRoute(10);
        return connManager;
    }

    public RequestConfig createRequestConfig() {
        return RequestConfig.DEFAULT;
    }

    @Override
    public void close() throws IOException {
        this.connectionManager.close(CloseMode.GRACEFUL);
    }
}

