/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.rest.httpclient4;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import net.linksfield.cube.partnersdk.rest.HttpFunction;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpResponse;
import net.linksfield.cube.partnersdk.rest.StatusCode;
import net.linksfield.cube.partnersdk.rest.httpclient4.HttpClient4Configuration;
import net.linksfield.cube.partnersdk.utils.GuavaUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient4Template
implements HttpFunction {
    private static final Logger log = LoggerFactory.getLogger(HttpClient4Template.class);
    private HttpClient4Configuration configuration;

    public HttpClient4Template(HttpClient4Configuration configuration) {
        log.debug("[Cube] The SDK will use HttpClient4 as the Http client implementation");
        this.configuration = configuration;
    }

    @Override
    public HttpResponse get(HttpRequest request) {
        return this.getDelete(request, HttpGet::new);
    }

    @Override
    public HttpResponse post(HttpRequest request) {
        return this.postPut(request, HttpPost::new);
    }

    @Override
    public HttpResponse put(HttpRequest request) {
        return this.postPut(request, HttpPut::new);
    }

    @Override
    public HttpResponse delete(HttpRequest request) {
        return this.getDelete(request, HttpDelete::new);
    }

    private HttpResponse getDelete(HttpRequest request, Function<URI, ? extends HttpRequestBase> httpMethod) {
        try {
            URIBuilder uriBuilder = new URIBuilder(request.getUrl());
            request.getQueryParams().forEach((key, value) -> uriBuilder.addParameter(key, value));
            HttpRequestBase get = httpMethod.apply(uriBuilder.build());
            this.addHeaders(get, request);
            return this.execute(get);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpResponse postPut(HttpRequest request, Function<URI, ? extends HttpEntityEnclosingRequestBase> httpMethod) {
        try {
            URIBuilder uriBuilder = new URIBuilder(request.getUrl());
            String contentType = GuavaUtils.getMultimapFirst(request.getHeaders(), "Content-Type");
            if ("x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                request.getQueryParams().forEach((key, value) -> uriBuilder.addParameter(key, value));
            }
            HttpEntityEnclosingRequestBase post = httpMethod.apply(uriBuilder.build());
            this.addHeaders((HttpRequestBase)post, request);
            if ("application/json".equalsIgnoreCase(contentType)) {
                this.addBody(post, request);
            }
            return this.execute((HttpRequestBase)post);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void addHeaders(HttpRequestBase httpRequest, HttpRequest requestWrapper) {
        requestWrapper.getHeaders().forEach((key, value) -> httpRequest.addHeader(key, value));
    }

    private void addBody(HttpEntityEnclosingRequestBase httpRequest, HttpRequest requestWrapper) {
        StringEntity stringEntity = new StringEntity(requestWrapper.getBodyString(), ContentType.APPLICATION_JSON);
        httpRequest.setEntity((HttpEntity)stringEntity);
    }

    private HttpResponse execute(HttpRequestBase httpRequest) {
        CloseableHttpClient httpClient = this.configuration.getClient();
        try {
            HttpResponse httpResponse = (HttpResponse)httpClient.execute((HttpUriRequest)httpRequest, (org.apache.http.client.ResponseHandler)new ResponseHandler());
            return httpResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        log.debug("now connection manager is httpclient4, close and shutdown connection pool");
        this.configuration.close();
    }

    private class ResponseHandler
    implements org.apache.http.client.ResponseHandler<HttpResponse> {
        private ResponseHandler() {
        }

        public HttpResponse handleResponse(org.apache.http.HttpResponse httpResponse) throws ClientProtocolException, IOException {
            HttpResponse response = new HttpResponse();
            StatusCode statusCode = new StatusCode();
            statusCode.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            statusCode.setReasonPhrase(httpResponse.getStatusLine().getReasonPhrase());
            response.setHttpStatus(statusCode);
            HashMultimap headers = HashMultimap.create();
            for (Header header : httpResponse.getAllHeaders()) {
                headers.put((Object)header.getName(), (Object)header.getValue());
            }
            response.setHeaders((Multimap<String, String>)headers);
            try (InputStream inputStream = httpResponse.getEntity().getContent();){
                byte[] bodyBytes = ByteStreams.toByteArray((InputStream)inputStream);
                response.setBodyResource(ByteSource.wrap((byte[])bodyBytes));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedOperationException e) {
                throw new RuntimeException(e);
            }
            return response;
        }
    }
}

