/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.rest;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestBuilder.class);
    protected BaseRequest domain;
    protected Map<String, Object> bodyMap;
    protected ServicesContainer servicesContainer;
    protected HttpRequest requestWrapper;

    public HttpRequestBuilder(BaseRequest domain, ServicesContainer servicesContainer) {
        this.domain = domain;
        this.servicesContainer = servicesContainer;
        this.requestWrapper = new HttpRequest();
        this.method(domain.getHttpMethod());
    }

    public HttpRequestBuilder method(HttpMethod method) {
        this.requestWrapper.setMethod(method);
        return this;
    }

    public HttpRequestBuilder requestUrl() {
        EndpointPropertiesProxy propertiesProxy = this.servicesContainer.getEndpointManager().getPropertiesProxy();
        String requestUrl = this.domain.requestUrl(propertiesProxy);
        if (log.isTraceEnabled()) {
            log.trace("domain:[{}] set request url to : {}", (Object)this.domain.getClass().getName(), (Object)requestUrl);
        }
        this.requestWrapper.setUrl(requestUrl);
        return this;
    }

    public HttpRequestBuilder headers(String signature) {
        HashMultimap headers = HashMultimap.create();
        if (this.domain.getExtendHeaders() != null) {
            headers.putAll(this.domain.getExtendHeaders());
        }
        headers.put((Object)"Authorization", (Object)("lf " + this.servicesContainer.getCommonVariables().getAccessKey() + "/" + signature));
        this.globalHeaders((Multimap<String, String>)headers);
        this.requestWrapper.setHeaders((Multimap<String, String>)headers);
        return this;
    }

    protected abstract void globalHeaders(Multimap<String, String> var1);

    public HttpRequestBuilder queryParams() {
        HashMultimap queryParams = HashMultimap.create();
        this.globalQueryParams((Multimap<String, String>)queryParams);
        this.domain.addQueryParams((Multimap<String, String>)queryParams);
        this.requestWrapper.setQueryParams((Multimap<String, String>)queryParams);
        return this;
    }

    public HttpRequestBuilder queryParam(String key, String value) {
        HashMultimap queryParams = this.requestWrapper.getQueryParams();
        if (queryParams == null) {
            queryParams = HashMultimap.create();
        }
        queryParams.put((Object)key, (Object)value);
        return this;
    }

    protected abstract void globalQueryParams(Multimap<String, String> var1);

    public HttpRequestBuilder body() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        this.globalBodyMap(body);
        this.domain.addBody(body);
        this.bodyMap = body;
        String bodyString = this.servicesContainer.getMessageConverter().getJsonSerializer().toJson(body);
        this.requestWrapper.setBodyString(bodyString);
        return this;
    }

    protected abstract void globalBodyMap(Map<String, Object> var1);

    public HttpRequest build() {
        return this.requestWrapper;
    }

    public Map<String, Object> getBodyMap() {
        return this.bodyMap;
    }

    public HttpRequest getRequestWrapper() {
        return this.requestWrapper;
    }
}

