/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;

public class EndpointManager {
    private EndpointPropertiesProxy propertiesProxy = this.loadEndpointFromProperties();

    public EndpointPropertiesProxy loadEndpointFromProperties() {
        String env = System.getProperty("linksfield.cube.partner.env", "prod");
        String customConfigPath = System.getProperty("linksfield.cube.partner.endpoint.path");
        String filename = Optional.ofNullable(customConfigPath).orElse("endpoint-" + env.toLowerCase() + ".properties");
        EndpointPropertiesProxy properties = new EndpointPropertiesProxy();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filename);){
            properties.load(inputStream);
            properties.bindingField();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public EndpointPropertiesProxy getPropertiesProxy() {
        return this.propertiesProxy;
    }
}

