/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Map;
import net.linksfield.cube.partnersdk.json.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonSerializer
implements JsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(JacksonJsonSerializer.class);
    private ObjectMapper linkedObjectMapper;
    private ObjectMapper objectMapper;

    public JacksonJsonSerializer() {
        log.debug("[Cube] The SDK will use Jackson as the Json serialization implementation");
        this.linkedObjectMapper = this.initLinkedObjectMapper();
        this.objectMapper = this.initObjectMapper();
    }

    private ObjectMapper initLinkedObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    private ObjectMapper initObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return objectMapper;
    }

    @Override
    public String toLinkedJson(Object value) {
        try {
            return this.linkedObjectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> convertMap(Object source) {
        return (Map)this.objectMapper.convertValue(source, Map.class);
    }

    @Override
    public <T> T parse(byte[] source, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(source, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

