/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.event;

import net.linksfield.cube.partnersdk.event.AsyncDispatcher;
import net.linksfield.cube.partnersdk.event.Event;
import net.linksfield.cube.partnersdk.event.EventHandler;
import net.linksfield.cube.partnersdk.event.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Events {
    private static final Logger log = LoggerFactory.getLogger(Events.class);
    private static Events instance = new Events();
    private AsyncDispatcher dispatcher = new AsyncDispatcher();

    private Events() {
        this.registerShutdownHook();
    }

    public static void register(EventType eventType, EventHandler eventHandler) {
        Events.instance.dispatcher.register(eventType, eventHandler);
    }

    public static void dispatch(Event event) {
        Events.instance.dispatcher.dispatch(event);
    }

    public static void start() {
        Events.instance.dispatcher.serviceStart();
    }

    public static void stop() {
        Events.instance.dispatcher.serviceStop();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("shutdown events dispatcher, release resources");
                Events.this.dispatcher.serviceStop();
            }
        });
    }
}

