/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.linksfield.cube.partnersdk.event.Dispatcher;
import net.linksfield.cube.partnersdk.event.Event;
import net.linksfield.cube.partnersdk.event.EventHandler;
import net.linksfield.cube.partnersdk.event.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDispatcher
implements Dispatcher {
    private static final Logger log = LoggerFactory.getLogger(AsyncDispatcher.class);
    private boolean running = false;
    private final ExecutorService eventHandlingPool;
    protected final Multimap<EventType, EventHandler> eventDispatchers = HashMultimap.create();

    public AsyncDispatcher() {
        this.eventHandlingPool = Executors.newSingleThreadExecutor();
    }

    public void serviceStart() {
        this.running = true;
    }

    public void serviceStop() {
        this.running = false;
        this.eventHandlingPool.shutdownNow();
    }

    @Override
    public void dispatch(Event event) {
        if (log.isDebugEnabled()) {
            log.debug("Dispatching the event {}.{}", (Object)event.getClass().getName(), (Object)event.toString());
        }
        EventType eventType = event.getType();
        try {
            if (this.eventDispatchers.containsKey((Object)eventType) && this.running) {
                Collection handlers = this.eventDispatchers.get((Object)eventType);
                this.eventHandlingPool.execute(new EventProcessTask(event, handlers));
            }
        }
        catch (Throwable t) {
            log.error("Event dispatcher throw error in {} , error:{}", (Object)this.getClass().getName(), (Object)t.getMessage());
        }
    }

    private void internalRegister(EventType eventType, EventHandler handler) {
        log.info("Event Registering [{}] for {}", (Object)eventType, handler.getClass());
        this.eventDispatchers.put((Object)eventType, (Object)handler);
    }

    @Override
    public void register(EventType eventType, EventHandler handler) {
        this.internalRegister(eventType, handler);
    }

    private class EventProcessTask
    implements Runnable {
        private Event event;
        private Collection<EventHandler> handlers;

        public EventProcessTask(Event event, Collection<EventHandler> handlers) {
            this.event = event;
            this.handlers = handlers;
        }

        @Override
        public void run() {
            log.debug("Event process for [{}] by {} handlers", (Object)this.event.getType(), (Object)this.handlers.size());
            for (EventHandler eventHandler : this.handlers) {
                eventHandler.handle(this.event);
            }
        }
    }
}

