/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.domain;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.SignatureBuilder;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.rest.HttpRequest;
import net.linksfield.cube.partnersdk.rest.HttpRequestBuilder;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureBuilderV2
extends SignatureBuilder {
    private static final Logger log = LoggerFactory.getLogger(SignatureBuilderV2.class);

    public SignatureBuilderV2(BaseRequest domain, ServicesContainer servicesContainer) {
        super(domain, servicesContainer);
    }

    @Override
    public void signature() {
        throw new IllegalStateException("not implements");
    }

    public void signature(HttpRequestBuilder httpRequestBuilder) {
        log.trace("domain:[{}] set all global parameters, build signature V2", (Object)this.domain.getClass().getName());
        this.createMapToSignWithGlobalParameters().addUrlSignatureParameters(this.mapToSign, httpRequestBuilder).addSignatureParameters(this.mapToSign, httpRequestBuilder).buildStringToSign(this.servicesContainer.getMessageConverter()).buildSignature(this.servicesContainer.getCommonVariables());
    }

    protected SignatureBuilderV2 addUrlSignatureParameters(Map<String, Object> mapToSign, HttpRequestBuilder httpRequestBuilder) {
        URI uri = URI.create(httpRequestBuilder.getRequestWrapper().getUrl());
        mapToSign.put("x-sign-uri", uri.getPath());
        return this;
    }

    private SignatureBuilderV2 addSignatureParameters(Map<String, Object> mapToSign, HttpRequestBuilder httpRequestBuilder) {
        HttpRequest httpRequest = httpRequestBuilder.getRequestWrapper();
        if (HttpMethod.GET.equals((Object)httpRequest.getMethod())) {
            httpRequest.getQueryParams().forEach((key, value) -> mapToSign.put((String)key, value));
        } else {
            mapToSign.putAll(httpRequestBuilder.getBodyMap());
        }
        return this;
    }

    @Override
    public SignatureBuilderV2 createMapToSignWithGlobalParameters() {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("timestamp", this.domain.getTimestamp());
        map.put("nonce", Integer.toString(this.domain.getNonce()));
        this.mapToSign = map;
        return this;
    }
}

