/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.domain;

import java.util.Map;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.CommonVariables;
import net.linksfield.cube.partnersdk.json.MessageConverter;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.utils.SignatureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureBuilder {
    private static final Logger log = LoggerFactory.getLogger(SignatureBuilder.class);
    protected BaseRequest domain;
    protected ServicesContainer servicesContainer;
    protected Map<String, Object> mapToSign;
    protected String stringToSign;
    protected String signature;

    public SignatureBuilder(BaseRequest domain, ServicesContainer servicesContainer) {
        this.domain = domain;
        this.servicesContainer = servicesContainer;
    }

    public abstract void signature();

    protected abstract SignatureBuilder createMapToSignWithGlobalParameters();

    protected SignatureBuilder addUrlSignatureParameters(Map<String, Object> mapToSign) {
        this.domain.addUrlSignatureParameters(mapToSign);
        return this;
    }

    protected SignatureBuilder buildStringToSign(MessageConverter messageConverter) {
        this.stringToSign = messageConverter.getJsonSerializer().toLinkedJson(this.mapToSign);
        return this;
    }

    protected SignatureBuilder buildSignature(CommonVariables commonVariables) {
        try {
            this.signature = SignatureUtils.sign(this.stringToSign, commonVariables.getPrivateKey());
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String build() {
        return this.signature;
    }

    public BaseRequest getDomain() {
        return this.domain;
    }

    public ServicesContainer getServicesContainer() {
        return this.servicesContainer;
    }

    public Map<String, Object> getMapToSign() {
        return this.mapToSign;
    }

    public String getStringToSign() {
        return this.stringToSign;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setDomain(BaseRequest domain) {
        this.domain = domain;
    }

    public void setServicesContainer(ServicesContainer servicesContainer) {
        this.servicesContainer = servicesContainer;
    }

    public void setMapToSign(Map<String, Object> mapToSign) {
        this.mapToSign = mapToSign;
    }

    public void setStringToSign(String stringToSign) {
        this.stringToSign = stringToSign;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureBuilder)) {
            return false;
        }
        SignatureBuilder other = (SignatureBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseRequest this$domain = this.getDomain();
        BaseRequest other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !((Object)this$domain).equals(other$domain)) {
            return false;
        }
        ServicesContainer this$servicesContainer = this.getServicesContainer();
        ServicesContainer other$servicesContainer = other.getServicesContainer();
        if (this$servicesContainer == null ? other$servicesContainer != null : !((Object)this$servicesContainer).equals(other$servicesContainer)) {
            return false;
        }
        Map<String, Object> this$mapToSign = this.getMapToSign();
        Map<String, Object> other$mapToSign = other.getMapToSign();
        if (this$mapToSign == null ? other$mapToSign != null : !((Object)this$mapToSign).equals(other$mapToSign)) {
            return false;
        }
        String this$stringToSign = this.getStringToSign();
        String other$stringToSign = other.getStringToSign();
        if (this$stringToSign == null ? other$stringToSign != null : !this$stringToSign.equals(other$stringToSign)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignatureBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseRequest $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : ((Object)$domain).hashCode());
        ServicesContainer $servicesContainer = this.getServicesContainer();
        result = result * 59 + ($servicesContainer == null ? 43 : ((Object)$servicesContainer).hashCode());
        Map<String, Object> $mapToSign = this.getMapToSign();
        result = result * 59 + ($mapToSign == null ? 43 : ((Object)$mapToSign).hashCode());
        String $stringToSign = this.getStringToSign();
        result = result * 59 + ($stringToSign == null ? 43 : $stringToSign.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public String toString() {
        return "SignatureBuilder(domain=" + this.getDomain() + ", servicesContainer=" + this.getServicesContainer() + ", mapToSign=" + this.getMapToSign() + ", stringToSign=" + this.getStringToSign() + ", signature=" + this.getSignature() + ")";
    }
}

