/*
 * Decompiled with CFR 0.152.
 */
package net.linksfield.cube.partnersdk.domain;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

public abstract class BaseRequest {
    protected HttpMethod httpMethod;
    protected String timestamp;
    protected int nonce;
    protected Multimap<String, String> extendHeaders;

    public BaseRequest(HttpMethod httpMethod, int nonce) {
        this.httpMethod = httpMethod;
        this.timestamp = Long.toString(System.currentTimeMillis());
        this.nonce = nonce;
        this.extendHeaders = HashMultimap.create();
        this.setContentType();
    }

    public abstract String requestUrl(EndpointPropertiesProxy var1);

    public abstract void addUrlSignatureParameters(Map<String, Object> var1);

    public abstract void addQueryParams(Multimap<String, String> var1);

    public abstract void addBody(Map<String, Object> var1);

    protected void setContentType() {
        this.extendHeaders.put((Object)"Content-Type", (Object)"application/json");
    }

    protected void addExtendHeader(String key, String value) {
        this.extendHeaders.put((Object)key, (Object)value);
    }

    protected void addOptionalQueryParam(Multimap<String, String> queryParams, String name, Object item) {
        if (item != null) {
            queryParams.put((Object)name, (Object)item.toString());
        }
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public int getNonce() {
        return this.nonce;
    }

    public Multimap<String, String> getExtendHeaders() {
        return this.extendHeaders;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setNonce(int nonce) {
        this.nonce = nonce;
    }

    public void setExtendHeaders(Multimap<String, String> extendHeaders) {
        this.extendHeaders = extendHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRequest)) {
            return false;
        }
        BaseRequest other = (BaseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNonce() != other.getNonce()) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        Multimap<String, String> this$extendHeaders = this.getExtendHeaders();
        Multimap<String, String> other$extendHeaders = other.getExtendHeaders();
        return !(this$extendHeaders == null ? other$extendHeaders != null : !this$extendHeaders.equals(other$extendHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNonce();
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        Multimap<String, String> $extendHeaders = this.getExtendHeaders();
        result = result * 59 + ($extendHeaders == null ? 43 : $extendHeaders.hashCode());
        return result;
    }

    public String toString() {
        return "BaseRequest(httpMethod=" + (Object)((Object)this.getHttpMethod()) + ", timestamp=" + this.getTimestamp() + ", nonce=" + this.getNonce() + ", extendHeaders=" + this.getExtendHeaders() + ")";
    }
}

