package net.linksfield.cube.partnersdk.sdk.proxy;

import net.linksfield.cube.partnersdk.sdk.SdkV2;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.sdk.SdkV1;

import java.lang.reflect.Proxy;
import java.util.function.Supplier;


/**
 * @ClassName ProxyHelper
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/21
 **/
public class ProxyHelper {
    public static SdkV1 createSdkV1Proxy(ServicesContainer servicesContainer) {
        // 创建一个对象代理
        AbstractSdkImplementProxy handler = new AbstractSdkV1ImplementProxy(servicesContainer);
        Object propertyInstance = Proxy.newProxyInstance(SdkV1.class.getClassLoader(), new Class[]{SdkV1.class}, handler);

        return (SdkV1) propertyInstance;
    }

    public static SdkV2 createSdkV2Proxy(ServicesContainer servicesContainer) {
        // 创建一个对象代理
        AbstractSdkImplementProxy handler = new AbstractSdkV2ImplementProxy(servicesContainer);
        Object propertyInstance = Proxy.newProxyInstance(SdkV2.class.getClassLoader(), new Class[]{SdkV2.class}, handler);

        return (SdkV2) propertyInstance;
    }


    public static Object createModuleProxy(Class<?> proxyClass, Supplier<AbstractModuleImplementProxy> moduleSupplier) {
        // 创建一个对象代理
        AbstractModuleImplementProxy handler = moduleSupplier.get();
        Object propertyInstance = Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, handler);

        return propertyInstance;
    }
}
