package net.linksfield.cube.partnersdk.sdk.proxy;

import net.linksfield.cube.partnersdk.sdk.ServicesContainer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName AbstractSdkImplementProxy
 * @Description SDK 模块筛选的动态代理
 * @Author James.hu
 * @Date 2023/3/15
 **/
public abstract class AbstractSdkImplementProxy implements InvocationHandler {

    protected ServicesContainer servicesContainer;

    /**
     * 动态代理了Module的接口实现
     * 假定第一个为BaseRequest类型, 并且只使用第一个参数调用 Http实现的发送方法
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        // 读取module map , 如果未缓存Module实例,则进行创建
        Object moduleCache = getModuleCache(method.getName(), method.getReturnType());
        return moduleCache;
    }

    private Object getModuleCache(String name, Class<?> moduleClass) {
        Object module = moduleMap.get(name);
        if (module == null) {
            module = buildModuleProxy(moduleClass, servicesContainer);
            moduleMap.put(name, module);
        }

        return module;
    }

    protected Object buildModuleProxy(Class<?> proxyClass, ServicesContainer servicesContainer) {
        return ProxyHelper.createModuleProxy(proxyClass, () -> createModuleProxy(servicesContainer));
    }

    protected abstract AbstractModuleImplementProxy createModuleProxy(ServicesContainer servicesContainer);

    protected Map<String, Object> moduleMap;

    public AbstractSdkImplementProxy(ServicesContainer servicesContainer) {
        this.servicesContainer = servicesContainer;
        this.moduleMap = new HashMap<>();
    }

}
