package net.linksfield.cube.partnersdk.sdk.proxy;

import net.linksfield.cube.partnersdk.domain.*;
import net.linksfield.cube.partnersdk.event.Events;
import net.linksfield.cube.partnersdk.event.events.DomainSignatureEvent;
import net.linksfield.cube.partnersdk.rest.*;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;

import java.util.function.Function;

/**
 * @ClassName AbstractModuleV1ImplementProxy
 * @Description V1 版本的SDK Module 动态代理实现
 * @Author James.hu
 * @Date 2023/3/21
 **/
public class AbstractModuleV2ImplementProxy extends AbstractModuleImplementProxy {
    public AbstractModuleV2ImplementProxy(ServicesContainer servicesContainer) {
        super(servicesContainer, Enums.SIGN_TYPE.V2);
    }

    protected ResponseBody execute(BaseRequest domain, Function<HttpRequest, HttpResponse> httpFunction) {
        SignatureBuilderV2 signatureBuilder = new SignatureBuilderV2(domain, servicesContainer);

        // 需要先构建http参数 除了header以外
        HttpRequestBuilder httpRequestBuilder = createRequestBuilder(domain)
                .requestUrl();

        if (HttpMethod.GET.equals(domain.getHttpMethod())) {
            httpRequestBuilder.queryParams();
        } else {
            httpRequestBuilder.body();
        }

        // 通过http参数来构建签名
        signatureBuilder.signature(httpRequestBuilder);

        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));

        // 再构建http headers
        httpRequestBuilder.headers(signature);

        // wrapper http parameters
        HttpRequest httpRequest = httpRequestBuilder.build();
        // 发送Http请求
        HttpResponse httpResponse = httpFunction.apply(httpRequest);

        return parseResponseBody(httpResponse);
    }

    @Override
    protected SignatureBuilder createSignatureBuilder(BaseRequest domain) {
        return new SignatureBuilderV2(domain, servicesContainer);
    }

    @Override
    protected HttpRequestBuilder createRequestBuilder(BaseRequest domain) {
        return new HttpRequestBuilderV2(domain, servicesContainer);
    }
}
