package net.linksfield.cube.partnersdk.sdk.modules.usage;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName GetSimUsage01
 * @Description Usage - get sim usage version uwp
 * @Author James.hu
 * @Date 2023/3/21
 **/
@Getter
public class GetSimUsageUwp extends BaseRequest {
    /**
     * SIM ICCID
     */
    private String simId;

    /**
     * Get SIM Usage
     * <p>Scenario：</p>
     * <p>Obtain the current Bundle/ package used by the SIM card from the beginning of the communication plan order to the last statistical time, and the accumulated data usage of the communication plan order.
     *  </p><br/>
     * <p>Business rules：</p>
     * <p>Only the order data of one communication plan that takes effect on the SIM card is collected.
     * Valid means an order whose order status is in use or suspended. Select priority in use higher than pause. If there are multiple orders in the same status, the order data whose enabled time is closest to the current time is returned.
     * Add on plan/Bundle and test data are not in the statistical range.
     * Communication plan order: refers to the basic unit for Lynco to control the SIM plan service and make traffic statistics. Usually, a communication package order will be generated in the system after the SIM card is bound with a package /Bundle, which is not directly displayed in the Cube 4.0 system.
     * Add on plan/bundle: refers to the data stacking service for specific resources and some services within a plan period.
     * Test data: indicates the ultra-small test data configured for the SIM card before delivery.
     * For more information, please consult our support staff.
     * </p><br/>
     * <p>Attention：</p>
     * <p><ul>
     * <li>The SIM card does not support OTA function.</li>
     * <li>The SIM card has only one Communication package order.</li>
     * <li>The lifecycle of the SIM card is Active-live or Paused.</li>
     * <li>To query the ICCID of the bound SIM card through the IMEI or SN of the device, useAPIGet SIM ID/ICCID</li>
     * </ul></p>
     * @param nonce
     * @param simId SIM ICCID
     */
    public GetSimUsageUwp(int nonce, String simId) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getUsage().getSimUsage01(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
