package net.linksfield.cube.partnersdk.sdk.modules.usage;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.List;
import java.util.Map;

/**
 * @ClassName GetSimUsage
 * @Description Usage - get sim usage
 * @Author James.hu
 * @Date 2023/3/21
 **/
@Getter
public class GetSimUsageA1 extends BaseRequest {
    /**
     * SIM ICCID
     */
    private List<String> simIds;

    /**
     * Get SIM Usage
     * only for A1
     */
    public GetSimUsageA1(int nonce, List<String> simIds) {
        super(HttpMethod.POST, nonce);
        this.simIds = simIds;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getUsage().getSimUsageA1();
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("sim_ids", simIds);
    }
}
