package net.linksfield.cube.partnersdk.sdk.modules.sms;

import com.google.common.collect.Lists;
import net.linksfield.cube.partnersdk.utils.AssertUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @ClassName SendSmsBuilder
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/21
 **/
public class SendSmsBuilder {
    /** Message Type enum , text */
    public static final int TYPE_TEXT = 1;
    /** Message Type enum , binary */
    public static final int TYPE_BINARY = 2;

    SendSmsBuilder(SendSms sendSms) {
        this.sendSms = sendSms;
    }

    private SendSms sendSms;

    /**
     * Destination list
     * @param iccids iccid list
     * @return SendSmsBuilder
     */
    public SendSmsBuilder iccids(Collection<String> iccids) {
        AssertUtils.isTrue(iccids.size() <= 100, "max 100 ICCIDs");
        List<String> simIds = new ArrayList<>(iccids);
        sendSms.setSimIds(simIds);
        return this;
    }

    /**
     * Destination list
     * @param iccids iccid list
     * @return SendSmsBuilder
     */
    public SendSmsBuilder iccids(String... iccids) {
        AssertUtils.isTrue(iccids != null && iccids.length <= 100, "max 100 ICCIDs");
        List<String> simIds = Lists.newArrayList(iccids);
        sendSms.setSimIds(simIds);
        return this;
    }

    /**
     * Message Type
     * @param type enum , 1-text ；2-binary
     * @return SendSmsBuilder
     */
    public SendSmsBuilder messageType(int type) {
        SendSms.Message message = makeMessageExist();
        message.setType(type);
        return this;
    }

    /**
     * Message content
     * @param content content
     * @return SendSmsBuilder
     */
    public SendSmsBuilder messageContent(String content) {
        AssertUtils.notNull(content, "content must not be null");
        AssertUtils.isTrue(content.length() <= 140, "max 140 characters");
        SendSms.Message message = makeMessageExist();
        message.setContent(content);
        return this;
    }

    public SendSms build() {
        AssertUtils.notNull(sendSms.getSimIds(), "iccids must not be null");
        AssertUtils.notNull(sendSms.getMessage(), "message type or content not be null");
        AssertUtils.isTrue(sendSms.getMessage().getType() == TYPE_TEXT || sendSms.getMessage().getType() == TYPE_BINARY, "message type allow value is [1 , 2]");
        AssertUtils.notNull(sendSms.getMessage().getContent(), "message content must not be null");
        return sendSms;
    }

    private SendSms.Message makeMessageExist() {
        SendSms.Message message = sendSms.getMessage();
        if (message == null) {
            message = new SendSms.Message();
        }
        sendSms.setMessage(message);
        return message;
    }
}
