package net.linksfield.cube.partnersdk.sdk.modules.sms;

import net.linksfield.cube.partnersdk.utils.AssertUtils;

/**
 * @ClassName ListMTBySimIdBuilder
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/22
 **/
public class ListMTBySimIdBuilder {
    private ListMTBySimId listMTBySimId;

    ListMTBySimIdBuilder(ListMTBySimId listMTBySimId, String simId) {
        this.listMTBySimId = listMTBySimId;
        this.listMTBySimId.setSimId(simId);
    }

    /**
     * query status, enum, 1-success, 2-failed, 3-processing, 4-all . default 4
     * @param status
     * @return
     */
    public ListMTBySimIdBuilder status(String status) {
        this.listMTBySimId.setStatus(status);
        return this;
    }

    /**
     * Long, Epoch timestamp UTC 0 in millisecond; default value is 7 days prior to the current time
     * @param beginFrom
     * @return
     */
    public ListMTBySimIdBuilder beginFrom(String beginFrom) {
        this.listMTBySimId.setBeginFrom(beginFrom);
        return this;
    }

    /**
     * Long, Epoch timestamp UTC 0 in millisecond; default current time
     * @param endBy
     * @return
     */
    public ListMTBySimIdBuilder endBy(String endBy) {
        this.listMTBySimId.setEndBy(endBy);
        return this;
    }

    /**
     * Page No default is 1
     * @param pageNo
     * @return
     */
    public ListMTBySimIdBuilder pageNo(Integer pageNo) {
        AssertUtils.isTrue(pageNo > 0, "Page no must be greater than or equal to 0");
        this.listMTBySimId.setPageNo(pageNo);
        return this;
    }

    /**
     * Page Size default is 100, range 1-100
     * @param pageSize
     * @return
     */
    public ListMTBySimIdBuilder pageSize(Integer pageSize) {
        AssertUtils.isTrue(pageSize > 0 && pageSize <= 100, "Page size range in [0, 100]");
        this.listMTBySimId.setPageSize(pageSize);
        return this;
    }

    public ListMTBySimId build() {
        return this.listMTBySimId;
    }

}
