package net.linksfield.cube.partnersdk.sdk.modules.sms;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName ListMTByJobId
 * @Description SMS - Retrieve list of SMS(mt) sent to the device, given the job ID of the sending request
 * @Author James.hu
 * @Date 2023/3/22
 **/
public class ListMTByJobId extends BaseRequestV2 {
    /** JOB ID , in the resoponse of send sms */
    private String jobId;

    /**
     * Retrieve list of SMS(mt) sent to the device, given the job ID of the sending request
     * @param nonce
     * @param jobId JOB ID , in the resoponse of send sms
     */
    public ListMTByJobId(int nonce, String jobId) {
        super(HttpMethod.GET, nonce);
        this.jobId = jobId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSms().listMTByJobId(jobId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
