package net.linksfield.cube.partnersdk.sdk.modules.sms;

import net.linksfield.cube.partnersdk.utils.AssertUtils;

/**
 * @ClassName ListMTBySimIdBuilder
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/22
 **/
public class ListMOBySimIdBuilder {
    private ListMOBySimId listMOBySimId;

    ListMOBySimIdBuilder(ListMOBySimId listMOBySimId, String simId) {
        this.listMOBySimId = listMOBySimId;
        this.listMOBySimId.setSimId(simId);
    }

    /**
     * query status, enum, 1-success, 2-failed, 3-processing, 4-all . default 4
     * @param status
     * @return
     */
    public ListMOBySimIdBuilder status(String status) {
        this.listMOBySimId.setStatus(status);
        return this;
    }

    /**
     * Long, Epoch timestamp UTC 0 in millisecond; default value is 7 days prior to the current time
     * @param beginFrom
     * @return
     */
    public ListMOBySimIdBuilder beginFrom(String beginFrom) {
        this.listMOBySimId.setBeginFrom(beginFrom);
        return this;
    }

    /**
     * Long, Epoch timestamp UTC 0 in millisecond; default current time
     * @param endBy
     * @return
     */
    public ListMOBySimIdBuilder endBy(String endBy) {
        this.listMOBySimId.setEndBy(endBy);
        return this;
    }

    /**
     * Page No default is 1
     * @param pageNo
     * @return
     */
    public ListMOBySimIdBuilder pageNo(Integer pageNo) {
        AssertUtils.isTrue(pageNo > 0, "Page no must be greater than or equal to 0");
        this.listMOBySimId.setPageNo(pageNo);
        return this;
    }

    /**
     * Page Size default is 100, range 1-100
     * @param pageSize
     * @return
     */
    public ListMOBySimIdBuilder pageSize(Integer pageSize) {
        AssertUtils.isTrue(pageSize > 0 && pageSize <= 100, "Page size range in [0, 100]");
        this.listMOBySimId.setPageSize(pageSize);
        return this;
    }

    public ListMOBySimId build() {
        return this.listMOBySimId;
    }

}
