package net.linksfield.cube.partnersdk.sdk.modules.sim;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName RetrieveSimStatus
 * @Description Query SIM's current status information
 * @Author James.hu
 * @Date 2023/3/17
 **/
public class SimStatus extends BaseRequest {

    /** SIM ICCID */
    private String simId;

    /**
     * query type
     * enum , supported: status
     */
    private String element;

    /**
     * Query SIM's current status information
     * @param nonce
     * @param simId SIM ICCID
     * @param element query type , enum , supported: status
     */
    public SimStatus(int nonce, String simId, String element) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
        this.element = element;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSim().simStatus(simId, element);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
        mapToSign.put("element", element);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }

}
