package net.linksfield.cube.partnersdk.sdk.modules.sim;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName QuerySim
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/30
 **/
public class QuerySim extends BaseRequestV2 {
    /** SIM ICCID */
    private String simId;

    /**
     * Query SIM's details
     * @param nonce
     * @param simId SIM ICCID
     */
    public QuerySim(int nonce, String simId) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSim().querySim(simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
