package net.linksfield.cube.partnersdk.sdk.modules.sim;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName QueryBundles
 * @Description Query SIM's bundles
 * @Author James.hu
 * @Date 2023/6/29
 **/
public class QueryBundlesAvailable extends BaseRequest {

    /** SIM ICCID */
    private String simId;

    /**
     * bundle type
     * enum , supported: 1 - Basic
     */
    private int type;

    public QueryBundlesAvailable(int nonce, String simId, int type) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
        this.type = type;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSim().queryBundlesAvailable(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        addOptionalQueryParam(queryParams, "type", type);
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }

}
