package net.linksfield.cube.partnersdk.sdk.modules.sim;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName QueryBundles
 * @Description Query SIM's bundles
 * @Author James.hu
 * @Date 2023/6/29
 **/
public class QueryBundles extends BaseRequest {

    /** SIM ICCID */
    private String simId;

    /**
     * query type
     * enum , supported: status
     */
    private String status;

    private int pageNo = 1;
    private int pageSize = 100;

    public QueryBundles(int nonce, String simId) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
    }

    public QueryBundles(int nonce, String simId, String status, int pageNo, int pageSize) {
        super(HttpMethod.GET, nonce);
        this.simId = simId;
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSim().queryBundles(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        addOptionalQueryParam(queryParams, "status", status);
        addOptionalQueryParam(queryParams, "page_no", pageNo);
        addOptionalQueryParam(queryParams, "page_size", pageSize);
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }

}
