package net.linksfield.cube.partnersdk.sdk.modules.sim;

import java.util.Collection;
import java.util.List;

/**
 * @ClassName ListMTBySimIdBuilder
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/22
 **/
public class BatchQuerySimBuilder {
    private BatchQuerySim batchQuerySim;

    BatchQuerySimBuilder(BatchQuerySim batchQuerySim) {
        this.batchQuerySim = batchQuerySim;
    }

    /**
     * Current Lifecycle
     * @param currentLifecycle
     * @return
     */
    public BatchQuerySimBuilder currentLifecycle(String currentLifecycle) {
        if (currentLifecycle == null || currentLifecycle.trim().length() == 0) {
            return this;
        }

        try {
            int status = Integer.parseInt(currentLifecycle);
            this.batchQuerySim.setStatus(status);
        } catch (NumberFormatException e) {
        }
        return this;
    }

    /**
     * Current Lifecycle
     * @param status
     * @return
     */
    public BatchQuerySimBuilder status(int status) {
        this.batchQuerySim.setStatus(status);
        return this;
    }

    /**
     * Page No default is 1
     * @param pageNo
     * @return
     */
    public BatchQuerySimBuilder pageNo(Integer pageNo) {
        this.batchQuerySim.setPageNo(pageNo);
        return this;
    }

    /**
     * Page Size default is 100, range 1-100
     * @param pageSize
     * @return
     */
    public BatchQuerySimBuilder pageSize(Integer pageSize) {
        this.batchQuerySim.setPageSize(pageSize);
        return this;
    }

    public BatchQuerySimBuilder orderId(String orderId) {
        this.batchQuerySim.setOrderId(orderId);
        return this;
    }

    /**
     * Add a sim id to the query parameter
     * @param simId
     * @return
     */
    public BatchQuerySimBuilder simId(String simId) {
        this.batchQuerySim.addSimId(simId);
        return this;
    }

    /**
     * Add a batch of sim ids to the query parameter
     * @param simIds
     * @return
     */
    public BatchQuerySimBuilder simIds(Collection<String> simIds) {
        this.batchQuerySim.makeSimIdsExist();
        this.batchQuerySim.getSimIds().addAll(simIds);
        return this;
    }

    /**
     * Add a batch of sim ids to the query parameter
     * @param simIds
     * @return
     */
    public BatchQuerySimBuilder simIds(String[] simIds) {
        this.batchQuerySim.makeSimIdsExist();
        for (String simId : simIds) {
            this.batchQuerySim.getSimIds().add(simId);
        }
        return this;
    }

    public BatchQuerySim build() {
        return this.batchQuerySim;
    }

}
