package net.linksfield.cube.partnersdk.sdk.modules.sim;

import com.google.common.collect.Multimap;
import lombok.Getter;
import lombok.Setter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName BatchQuerySim
 * @Description TODO
 * @Author James.hu
 * @Date 2023/4/12
 **/
@Getter
@Setter
public class BatchQuerySim extends BaseRequestV2 {
    /**
     * 10,Pre-active，静默期
     * 23,Active-live，使用期，可入网，正式Bundle使用中。
     * 30,Paused，暂停期，不可入网，需resume后恢复。
     * 40,Expired，停机保期，不可入网。
     * 50,Terminated，废弃期，不可入网。
     */
    private Integer status;
    private int pageNo = 1;
    private int pageSize = 100;
    private String orderId;
    private List<String> simIds;

    public BatchQuerySim(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public BatchQuerySim(HttpMethod httpMethod, int nonce, Integer status, int pageNo, int pageSize) {
        super(httpMethod, nonce);
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public BatchQuerySim(HttpMethod httpMethod, int nonce, Integer status, int pageNo, int pageSize, String orderId) {
        super(httpMethod, nonce);
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderId = orderId;
    }

    public BatchQuerySim(HttpMethod httpMethod, int nonce, Integer status, int pageNo, int pageSize, String orderId, List<String> simIds) {
        super(httpMethod, nonce);
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderId = orderId;
        this.simIds = simIds;
    }

    public static BatchQuerySimBuilder builder(int nonce) {
        return new BatchQuerySimBuilder(new BatchQuerySim(nonce));
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getSim().batchQuerySim();
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        addOptionalQueryParam(queryParams, "status", status);
        addOptionalQueryParam(queryParams, "page_no", pageNo);
        addOptionalQueryParam(queryParams, "page_size", pageSize);
        addOptionalQueryParam(queryParams, "order_id", orderId);
        addOptionalQueryParam(queryParams, "sim_ids", simIds.stream().collect(Collectors.joining(",")));
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }

    void makeSimIdsExist() {
        if (this.simIds == null) {
            this.simIds = new ArrayList<>(100);
        }
    }
    void addSimId(String simId) {
        makeSimIdsExist();
        this.simIds.add(simId);
    }
}
