package net.linksfield.cube.partnersdk.sdk.modules.service;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName SwitchBundle
 * @Description Service - switch bundle
 * @Author James.hu
 * @Date 2023/3/21
 **/
@Getter
public class SwitchBundle extends BaseRequest {
    /**
     * SIM ICCID
     */
    private String simId;

    /** Bundle ID */
    private String bundleId;

    /** Number of add cycles. This value does not take effect when the type is 11- add on. If the type is 10 - basic, the value is mandatory. If it is empty, the value is 1 by default */
    private int cycles;

    public SwitchBundle(int nonce, String simId, String bundleId, int cycles) {
        super(HttpMethod.PUT, nonce);
        this.simId = simId;
        this.bundleId = bundleId;
        this.cycles = cycles;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getService().addBundle(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
//        mapToSign.put("sim_id", simId);
//        mapToSign.put("bundle_id", bundleId);
//        mapToSign.put("cycles", cycles);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("sim_id", simId);
        body.put("bundle_id", bundleId);
        body.put("cycles", cycles);
    }
}
