package net.linksfield.cube.partnersdk.sdk.modules.service;

import net.linksfield.cube.partnersdk.domain.*;
import net.linksfield.cube.partnersdk.event.Events;
import net.linksfield.cube.partnersdk.event.events.DomainSignatureEvent;
import net.linksfield.cube.partnersdk.rest.*;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.sdk.proxy.extend.IModuleExecutor;
import org.apache.http.HttpStatus;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

/**
 * @ClassName SuspendModuleExecutor
 * @Description suspend
 * @Author James.hu
 * @Date 2023/4/11
 **/
public class SuspendModuleExecutor implements IModuleExecutor {

    @Override
    public ResponseBody execute(Enums.SIGN_TYPE signType, BaseRequest domain, ServicesContainer servicesContainer) {
        if (Enums.SIGN_TYPE.V2.equals(signType)) {
            return executeV2(domain, servicesContainer);
        } else {
            return executeV1(domain, servicesContainer);
        }
    }

    private ResponseBody executeV2(BaseRequest domain, ServicesContainer servicesContainer) {
        SignatureBuilderV2 signatureBuilder = new SignatureBuilderV2(domain, servicesContainer);

        // 需要先构建http参数 除了header以外
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilderV2(domain, servicesContainer).requestUrl();

        httpRequestBuilder.queryParams().body();


        // 通过http参数来构建签名
        signatureBuilder.signature(httpRequestBuilder);

        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));

        // 再构建http headers
        httpRequestBuilder.headers(signature);

        // wrapper http parameters
        HttpRequest httpRequest = httpRequestBuilder.build();
        // 发送Http请求
        HttpResponse httpResponse = servicesContainer.getHttpClientManager().put(httpRequest);

        return parseResponseBody(httpResponse, servicesContainer);
    }

    private ResponseBody executeV1(BaseRequest domain, ServicesContainer servicesContainer) {
        SignatureBuilder signatureBuilder = new SignatureBuilderV1(domain, servicesContainer);
        signatureBuilder.signature();

        String signature = signatureBuilder.build();
        Events.dispatch(new DomainSignatureEvent(signature, signatureBuilder.getStringToSign()));

        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilderV1(domain, servicesContainer);
        httpRequestBuilder.requestUrl().headers(signature);
        httpRequestBuilder.queryParams();

        // wrapper http parameters
        HttpRequest httpRequest = httpRequestBuilder.build();
        // 发送Http请求
        HttpResponse httpResponse = servicesContainer.getHttpClientManager().put(httpRequest);

        return parseResponseBody(httpResponse, servicesContainer);
    }

    protected ResponseBody parseResponseBody(HttpResponse httpResponse, ServicesContainer servicesContainer) {
        // 解析接收到的响应结果
        try {
            ResponseBody responseBody = servicesContainer.getMessageConverter().getJsonSerializer().parse(httpResponse.getBodyResource().read(), ResponseBody.class);
            httpResponse.setBody(responseBody);

            return responseBody;
        } catch (IOException | RuntimeException e) {
            try {
                String source = httpResponse.getBodyResource().asCharSource(StandardCharsets.UTF_8).read();
                ResponseBodyString responseBody = new ResponseBodyString(source);
                httpResponse.setBody(responseBody);
                StatusCode statusCode = new StatusCode();
                statusCode.setStatusCode(HttpStatus.SC_INTERNAL_SERVER_ERROR);
                statusCode.setReasonPhrase(e.getMessage());
                httpResponse.setHttpStatus(statusCode);

                return responseBody;
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}
