package net.linksfield.cube.partnersdk.sdk.modules.service;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName SuspendAsync
 * @Description Service - suspend async
 * @Author James.hu
 * @Date 2023/3/21
 **/
@Getter
public class SuspendAsync extends BaseRequest {
    /**
     * SIM ICCID
     */
    private String simId;

    /**
     * Suspend the SIM service
     * @param nonce
     * @param simId SIM ICCID
     */
    public SuspendAsync(int nonce, String simId) {
        super(HttpMethod.PUT, nonce);
        this.simId = simId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getService().suspendAsync(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("sim_id", simId);
    }
}
