package net.linksfield.cube.partnersdk.sdk.modules.service;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpHeaders;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.rest.MediaType;

import java.util.Map;

/**
 * @ClassName Suspend
 * @Description Service - suspend
 * @Author James.hu
 * @Date 2023/3/21
 **/
@Getter
@Deprecated
public class Suspend extends BaseRequest {
    /** SIM ICCID */
    private String simId;

    /**
     * suspend date
     * yyyy-MM-dd utc+8
     * required
    */
    private String suspendDate;

    /**
     * active data
     * yyyy-MM-dd utc+8
     * required
     */
    private String activateDate;

    /**
     * Suspend the SIM service.
     * @param nonce
     * @param simId SIM ICCID
     * @param suspendDate suspend date yyyy-MM-dd utc+8
     * @param activateDate active date yyyy-MM-dd utc+8
     */
    public Suspend(int nonce, String simId, String suspendDate, String activateDate) {
        super(HttpMethod.PUT, nonce);
        this.simId = simId;
        this.suspendDate = suspendDate;
        this.activateDate = activateDate;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getService().suspend(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
        mapToSign.put("suspend_date", suspendDate);
        mapToSign.put("activate_date", activateDate);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        queryParams.put("suspend_date", suspendDate);
        queryParams.put("activate_date", activateDate);
    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("suspend_date", suspendDate);
        body.put("activate_date", activateDate);
    }

    @Override
    protected void setContentType() {
        super.addExtendHeader(HttpHeaders.ContentType, MediaType.X_WWW_FORM_URLENCODED);
    }
}
