package net.linksfield.cube.partnersdk.sdk.modules.service;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName ServiceActivateAsync
 * @Description Service - Activate Async
 * @Author James.hu
 * @Date 2023/3/14
 **/
@Getter
public class ActivateAsync extends BaseRequest {
    /**
     * SIM ICCID
     */
    private String simId;

    /**
     * Activate SIM to use bundle
     * @param nonce
     * @param simId SIM ICCID
     */
    public ActivateAsync(int nonce, String simId) {
        super(HttpMethod.POST, nonce);
        this.simId = simId;
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {
        body.put("sim_id", simId);
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getService().activateAsync(simId);
    }
}
