package net.linksfield.cube.partnersdk.sdk.modules.other;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName SwitchBundleForOta
 * @Description Other - Switch bundle for OTA SIM
 * @Author James.hu
 * @Date 2023/3/22
 **/
@Deprecated
@Getter
public class SwitchBundleForOta extends BaseRequest {
    private String simId;

    public SwitchBundleForOta(int nonce, String simId) {
        super(HttpMethod.POST, nonce);
        this.simId = simId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOther().switchBundleForOta(simId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("sim_id", simId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
