package net.linksfield.cube.partnersdk.sdk.modules.other;

import net.linksfield.cube.partnersdk.utils.AssertUtils;

/**
 * @ClassName SimMoListBuilder
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/22
 **/
public class SimMoListBuilder {
    private SimMoList simMoList;

    SimMoListBuilder(SimMoList simMoList, String queryType, String value) {
        this.simMoList = simMoList;
        this.simMoList.setQueryType(queryType);
        this.simMoList.setValue(value);
    }

    public SimMoListBuilder receivedStartTime(String receivedStartTime) {
        this.simMoList.setReceivedStartTime(receivedStartTime);
        return this;
    }

    public SimMoListBuilder receivedEndBy(String receivedEndBy) {
        this.simMoList.setReceivedEndBy(receivedEndBy);
        return this;
    }

    public SimMoListBuilder pageNo(Integer pageNo) {
        AssertUtils.isTrue(pageNo > 0, "Page no must be greater than or equal to 0");
        this.simMoList.setPageNo(pageNo);
        return this;
    }

    public SimMoListBuilder pageSize(Integer pageSize) {
        AssertUtils.isTrue(pageSize > 0, "Page size must be greater then or equal to 0");
        this.simMoList.setPageSize(pageSize);
        return this;
    }

    public SimMoList build() {
        return this.simMoList;
    }



}
