package net.linksfield.cube.partnersdk.sdk.modules.other;

import com.google.common.collect.Multimap;
import lombok.Getter;
import lombok.Setter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName SimMoList
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/22
 **/
@Deprecated
@Setter
@Getter
public class SimMoList extends BaseRequest {

    private String queryType;
    private String value;
    private String receivedStartTime;
    private String receivedEndBy;
    private Integer pageNo;
    private Integer pageSize;

    public SimMoList(int nonce, String queryType, String value, String receivedStartTime, String receivedEndBy, Integer pageNo, Integer pageSize) {
        super(HttpMethod.GET, nonce);
        this.queryType = queryType;
        this.value = value;
        this.receivedStartTime = receivedStartTime;
        this.receivedEndBy = receivedEndBy;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    private SimMoList(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public static SimMoListBuilder builder(int nonce, String queryType, String value) {
        return new SimMoListBuilder(new SimMoList(nonce), queryType, value);
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOther().listMO01(queryType, value);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("query_type", queryType);
        mapToSign.put("value", value);
        if (receivedStartTime != null) {
            mapToSign.put("received_start_time", receivedStartTime);
        }
        if (receivedEndBy != null) {
            mapToSign.put("received_end_by", receivedEndBy);
        }
        if (pageNo != null) {
            mapToSign.put("page_no", pageNo);
        }
        if (pageSize != null) {
            mapToSign.put("page_size", pageSize);
        }
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        if (receivedStartTime != null) {
            queryParams.put("received_start_time", receivedStartTime);
        }
        if (receivedEndBy != null) {
            queryParams.put("received_end_by", receivedEndBy);
        }
        if (pageNo != null) {
            queryParams.put("page_no", pageNo.toString());
        }
        if (pageSize != null) {
            queryParams.put("page_size", pageSize.toString());
        }
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
