package net.linksfield.cube.partnersdk.sdk.modules.other;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName OrderDailyUsage
 * @Description TODO
 * @Author James.hu
 * @Date 2023/3/22
 **/
@Deprecated
@Getter
public class OrderDailyUsage extends BaseRequest {
    private String orderId;
    private String simId;
    private String queryStartDate;
    private String createEndBy;

    public OrderDailyUsage(int nonce, String orderId, String simId, String queryStartDate, String createEndBy) {
        super(HttpMethod.GET, nonce);
        this.orderId = orderId;
        this.simId = simId;
        this.queryStartDate = queryStartDate;
        this.createEndBy = createEndBy;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOther().orderDailyUsage(orderId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("order_id", orderId);
        mapToSign.put("sim_id", simId);
        mapToSign.put("query_start_date", queryStartDate);
        mapToSign.put("create_end_by", createEndBy);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        queryParams.put("sim_id", simId);
        queryParams.put("query_start_date", queryStartDate);
        queryParams.put("create_end_by", createEndBy);
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
