package net.linksfield.cube.partnersdk.sdk.modules.other;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName AsyncResult
 * @Description Other - Query Async method result
 * @Author James.hu
 * @Date 2023/3/17
 **/
@Getter
public class AsyncResult extends BaseRequest {

    /** Async Request id */
    private String requestId;

    /**
     * Query SIM action result
     * @param nonce
     * @param requestId Async request id
     */
    public AsyncResult(int nonce, String requestId) {
        super(HttpMethod.GET, nonce);
        this.requestId = requestId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOther().asyncResult(requestId);
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("request_id", requestId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }

}
