package net.linksfield.cube.partnersdk.sdk.modules.orders;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName QueryOrder
 * @Description orderlite - query an order
 * @Author James.hu
 * @Date 2023/3/30
 **/
public class QueryOrder extends BaseRequestV2 {
    private String orderId;

    /**
     * Query Order's details
     * @param nonce
     * @param orderId Order identity
     */
    public QueryOrder(int nonce, String orderId) {
        super(HttpMethod.GET, nonce);
        this.orderId = orderId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOrders().queryOrder(orderId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
