package net.linksfield.cube.partnersdk.sdk.modules.orders;

import com.google.common.collect.Multimap;
import lombok.Setter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName QueryCoverage
 * @Description Query coverage data
 * @Author James.hu
 * @Date 2023/3/30
 **/
@Setter
public class QueryCoverage extends BaseRequestV2 {
    /** Coverage identity */
    private String coverageId;

    /**
     * Query coverage data by id
     * @param nonce
     * @param coverageId coverage identity
     */
    public QueryCoverage(int nonce, String coverageId) {
        super(HttpMethod.GET, nonce);
        this.coverageId = coverageId;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOrders().coverageFindOne(coverageId);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
