package net.linksfield.cube.partnersdk.sdk.modules.orders;

import com.google.common.collect.Multimap;
import lombok.AllArgsConstructor;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;
import net.linksfield.cube.partnersdk.utils.AssertUtils;
import net.linksfield.cube.partnersdk.utils.ReflectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @ClassName PlaceOrder
 * @Description Orderlite - place an order
 * @Author James.hu
 * @Date 2023/3/17
 **/
public class PlaceOrder extends BaseRequestV2 {

    private PlaceOrder(int nonce) {
        super(HttpMethod.POST, nonce);
        this.skus = new ArrayList<>();
    }

    public static PlaceOrderBuilder builder(int nonce) {
        PlaceOrder domain = new PlaceOrder(nonce);
        PlaceOrderBuilder builder = new PlaceOrderBuilder(domain);
        return builder;
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOrders().order();
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {

    }

    public static PlaceOrder customization(int nonce, Map<String, Object> customBody) {
        return new PlaceOrder(nonce) {
            @Override
            public void addBody(Map<String, Object> body) {
                body.putAll(customBody);
            }
        };
    }

    List<Sku> skus;
    Accounting accounting;
    Extra extra;
    DeliveryAddress address;
    Contact contact;

    @Override
    public void addBody(Map<String, Object> body) {
        AssertUtils.isTrue(skus.size() > 0, "The product list is a required");
        AssertUtils.notNull(address, "The shipping address information is required");
        AssertUtils.notNull(contact, "The consignee information is required");

        body.put("items", ReflectUtils.objectToMap(skus));
        Optional.ofNullable(extra).ifPresent(ex -> body.put("extra", ReflectUtils.objectToMap(ex)));
        Optional.ofNullable(accounting).ifPresent(ex -> body.put("accounting", ReflectUtils.objectToMap(ex)));
        body.put("delivery_address", ReflectUtils.objectToMap(address));
        body.put("contact", ReflectUtils.objectToMap(contact));
    }


    @Getter
    public static class Sku {
        private int price;
        private int quantity;
        private String id;

        public Sku(String id, int quantity, int price) {
            this.id = id;
            this.quantity = quantity;
            this.price = price;
        }
    }

    @Getter
    public static class Accounting {
        private String currency;
        private int pay_channel;
        private String coupon_id;
        private Integer discount;

        public Accounting(String currency, int pay_channel) {
            this.currency = currency;
            this.pay_channel = pay_channel;
        }

        public Accounting(String currency, int pay_channel, String coupon_id) {
            this.currency = currency;
            this.pay_channel = pay_channel;
            this.coupon_id = coupon_id;
        }

        public Accounting(String currency, int pay_channel, String coupon_id, Integer discount) {
            this.currency = currency;
            this.pay_channel = pay_channel;
            this.coupon_id = coupon_id;
            this.discount = discount;
        }

        public Accounting() {
            this.currency = "CNY";
            this.pay_channel = 1;
        }
    }

    @Getter
    @AllArgsConstructor
    public static class Extra {
        private String po;
        private String remarks;
    }

    @Getter
    @AllArgsConstructor
    public static class DeliveryAddress {
        private String country;
        private String province;
        private String city;
        private String district;
        private String town;
        private String detail;
        private String zip;
        private String special_instructions;

        public DeliveryAddress(String country, String province, String city, String detail) {
            this.country = country;
            this.province = province;
            this.city = city;
            this.detail = detail;
        }
    }

    @Getter
    @AllArgsConstructor
    public static class Contact {
        private String name;
        private String tel_area;
        private String tel_code;
        private String mobile_no;
        private String mobile_area;
        private String email;

        public Contact(String name, String mobile_no) {
            this.name = name;
            this.mobile_no = mobile_no;
            this.mobile_area = "86";
        }
    }

}
