package net.linksfield.cube.partnersdk.sdk.modules.orders;

import net.linksfield.cube.partnersdk.utils.AssertUtils;

/**
 * @ClassName ListSkusBuilder
 * @Description Query customer skus list builder
 * @Author James.hu
 * @Date 2023/3/22
 **/
public class ListSkusBuilder {
    private ListSkus querySkus;

    ListSkusBuilder(ListSkus querySkus) {
        this.querySkus = querySkus;
    }

    /**
     * product category, enum, 1-SIM+BUNDLE
     * @param category
     * @return
     */
    public ListSkusBuilder category(Integer category) {
        this.querySkus.setCategory(category);
        return this;
    }

    /**
     * query status, enum, 1-Enabled ；2-Disabled；3-Discard；4-All
     * @param status
     * @return
     */
    public ListSkusBuilder status(Integer status) {
        this.querySkus.setStatus(status);
        return this;
    }

    /**
     * Page No default is 1
     * @param pageNo
     * @return
     */
    public ListSkusBuilder pageNo(Integer pageNo) {
        AssertUtils.isTrue(pageNo > 0, "Page no must be greater than or equal to 0");
        this.querySkus.setPageNo(pageNo);
        return this;
    }

    /**
     * Page Size default is 100, range 1-100
     * @param pageSize
     * @return
     */
    public ListSkusBuilder pageSize(Integer pageSize) {
        AssertUtils.isTrue(pageSize > 0 && pageSize <= 100, "Page size range in [0, 100]");
        this.querySkus.setPageSize(pageSize);
        return this;
    }

    public ListSkus build() {
        return this.querySkus;
    }

}
