package net.linksfield.cube.partnersdk.sdk.modules.orders;

import com.google.common.collect.Multimap;
import lombok.Setter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequestV2;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName ListSkus
 * @Description Query customer skus list
 * @Author James.hu
 * @Date 2023/3/30
 **/
@Setter
public class ListSkus extends BaseRequestV2 {
    /** Product category：1-SIM+BUNDLE */
    private Integer category;

    /** 1-Enabled ；2-Disabled；3-Discard；4-All */
    private Integer status;

    private Integer pageNo;

    private Integer pageSize;

    /**
     * Query SIM's details
     * @param nonce
     * @param category Product category
     * @param status Product status
     * @param pageNo page number
     * @param pageSize page size
     */
    public ListSkus(int nonce, Integer category, Integer status, Integer pageNo, Integer pageSize) {
        super(HttpMethod.GET, nonce);
        this.category = category;
        this.status = status;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    /**
     * Query SIM's details
     * @param nonce
     */
    public ListSkus(int nonce) {
        super(HttpMethod.GET, nonce);
    }

    public static ListSkusBuilder builder(int nonce) {
        return new ListSkusBuilder(new ListSkus(nonce));
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getOrders().list();
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        addOptionalQueryParam(queryParams, "category", category);
        addOptionalQueryParam(queryParams, "status", status);
        addOptionalQueryParam(queryParams, "page_no", pageNo);
        addOptionalQueryParam(queryParams, "page_size", pageSize);
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }
}
