package net.linksfield.cube.partnersdk.sdk.modules.mall;

import com.google.common.collect.Multimap;
import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.rest.HttpMethod;

import java.util.Map;

/**
 * @ClassName Refunds
 * @Description Mall - Get refund list
 * @Author James.hu
 * @Date 2023/3/17
 **/
@Deprecated
@Getter
public class Refunds extends BaseRequest {

    /** Start time of successful refund. Time zone :GMT+0 in the format YYYY-MM-DD HH: MM: SS */
    private String createStartTime;

    /** Successful refund end time. Within 365 days (inclusive) from the start time. Time zone :GMT+0 in the format YYYY-MM-DD HH: MM: SS */
    private String createEndBy;

    /** The page number. Default :1, a fillable integer that controls the number of pages fetched by passing in pagE_no, total number of pages = TOTAL_results ÷ PAGE_size. If this parameter is not passed, use the default value. */
    private Integer pageNo;

    /** Number of items per page. Default value: 10; Maximum value :100. The value can be an integer. Through page_no and page_size combination of multiple calls to achieve page turning to obtain full data. If this parameter is not passed, use the default value. */
    private Integer pageSize;

    /**
     * Query mall order records within 365 days
     * @param nonce
     * @param createStartTime Start time of successful refund. Time zone :GMT+0 in the format YYYY-MM-DD HH: MM: SS
     * @param createEndBy Successful refund end time. Within 365 days (inclusive) from the start time. Time zone :GMT+0 in the format YYYY-MM-DD HH: MM: SS
     * @param pageNo The page number. Default :1, a fillable integer that controls the number of pages fetched by passing in pagE_no, total number of pages = TOTAL_results ÷ PAGE_size. If this parameter is not passed, use the default value.
     * @param pageSize Number of items per page. Default value: 10; Maximum value :100. The value can be an integer. Through page_no and page_size combination of multiple calls to achieve page turning to obtain full data. If this parameter is not passed, use the default value.
     */
    public Refunds(int nonce, String createStartTime, String createEndBy, Integer pageNo, Integer pageSize) {
        super(HttpMethod.GET, nonce);
        this.createStartTime = createStartTime;
        this.createEndBy = createEndBy;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    /**
     * Query mall order records within 365 days
     * <p>Set page no to 1</p>
     * <p>Set page size to 10</p>
     * @param nonce
     * @param createStartTime Start time of successful refund. Time zone :GMT+0 in the format YYYY-MM-DD HH: MM: SS
     * @param createEndBy Successful refund end time. Within 365 days (inclusive) from the start time. Time zone :GMT+0 in the format YYYY-MM-DD HH: MM: SS
     */
    public Refunds(int nonce, String createStartTime, String createEndBy) {
        this(nonce, createStartTime, createEndBy, 1, 10);
    }

    @Override
    public String requestUrl(EndpointPropertiesProxy endpointPropertiesProxy) {
        return endpointPropertiesProxy.getMall().refunds();
    }

    @Override
    public void addUrlSignatureParameters(Map<String, Object> mapToSign) {
        mapToSign.put("create_start_time", createStartTime);
        mapToSign.put("create_end_by", createEndBy);
        mapToSign.put("page_no", pageNo);
        mapToSign.put("page_size", pageSize);
    }

    @Override
    public void addQueryParams(Multimap<String, String> queryParams) {
        queryParams.put("create_start_time", createStartTime);
        queryParams.put("create_end_by", createEndBy);
        queryParams.put("page_no", pageNo.toString());
        queryParams.put("page_size", pageSize.toString());
    }

    @Override
    public void addBody(Map<String, Object> body) {

    }

}
