package net.linksfield.cube.partnersdk.sdk.modules.cdr;

import net.linksfield.cube.partnersdk.utils.AssertUtils;

/**
 * @ClassName SimCdrBuilder
 * @Description Sim Cdr query builder
 * @Author James.hu
 * @Date 2023/3/21
 **/
public class SimCdrBuilder {
    private SimCdr simCdr;

    SimCdrBuilder(SimCdr simCdr, String simId) {
        this.simCdr = simCdr;
        this.simCdr.setSimId(simId);
    }

    public SimCdrBuilder receivedStartTime(String receivedStartTime) {
        this.simCdr.setReceivedStartTime(receivedStartTime);
        return this;
    }

    public SimCdrBuilder receivedEndBy(String receivedEndBy) {
        this.simCdr.setReceivedEndBy(receivedEndBy);
        return this;
    }

    public SimCdrBuilder pageNo(Integer pageNo) {
        AssertUtils.isTrue(pageNo > 0, "Page no must be greater than or equal to 0");
        this.simCdr.setPageNo(pageNo);
        return this;
    }

    public SimCdrBuilder pageSize(Integer pageSize) {
        AssertUtils.isTrue(pageSize > 0, "Page size must be greater then or equal to 0");
        this.simCdr.setPageSize(pageSize);
        return this;
    }

    public SimCdr build() {
        return simCdr;
    }
}
