package net.linksfield.cube.partnersdk.rest;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName PartnerResponseStatus
 * @Description 响应状态
 * @Author James.hu
 * @Date 2023/3/14
 **/
@Data
public class ResponseStatus implements Serializable {
    private static final long serialVersionUID = -4887052142615452625L;

    private static final String CODE_SUCCESS = "0000";

    /** 状态码 */
    private String code;
    /** 提示信息 */
    private String message;
    /** 错误详情 */
    private Object detail;
    /** 计算属性 请求结果是否成功 */
    private boolean success;

    public boolean isSuccess() {
        return this.code.endsWith(CODE_SUCCESS);
    }
}
