package net.linksfield.cube.partnersdk.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Multimap;
import lombok.Data;

import java.io.Serializable;

/**
 * @ClassName PartnerResponse
 * @Description 接口响应结构
 * @Author James.hu
 * @Date 2023/3/14
 **/
@Data
public class ResponseBody implements Serializable {
    private static final long serialVersionUID = 854833320704897953L;

    /** Response status */
    private ResponseStatus status;
    /** Response Body */
    private Object data;
    /** Optional : Business serial number */
    private String requestId;
    /** Optional : Log trace id */
    private String traceId;

    @JsonProperty("total_count")
    private Object totalCount;

    /** Response Header */
    private Multimap<String, String> headers;
}
