package net.linksfield.cube.partnersdk.rest;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.Enums;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;

import java.util.Map;

/**
 * @ClassName HttpRequestBuilderV1
 * @Description V2版本 Http请求构造器
 * @Author James.hu
 * @Date 2023/3/20
 **/
public class HttpRequestBuilderV2 extends HttpRequestBuilder {
    public HttpRequestBuilderV2(BaseRequest domain, ServicesContainer servicesContainer) {
        super(domain, servicesContainer);
    }

    @Override
    protected void globalHeaders(Multimap<String, String> headers) {
        headers.put("Accept-Language", servicesContainer.getCommonVariables().getAcceptLanguage());
        headers.put("X-LF-Api-Version", Enums.API_VERSION.V1.version);
        headers.put("X-LF-Signature-Type", Enums.SIGN_TYPE.V2.version);
        headers.put("timestamp", domain.getTimestamp());
        headers.put("nonce", Integer.toString(domain.getNonce()));
    }

    @Override
    protected void globalQueryParams(Multimap<String, String> queryParams) {

    }

    @Override
    protected void globalBodyMap(Map<String, Object> body) {

    }
}
