package net.linksfield.cube.partnersdk.rest;

import com.google.common.collect.Multimap;
import net.linksfield.cube.partnersdk.domain.BaseRequest;
import net.linksfield.cube.partnersdk.domain.Enums;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;

import java.util.Map;

/**
 * @ClassName HttpRequestBuilderV1
 * @Description V1版本 Http请求构造器
 * @Author James.hu
 * @Date 2023/3/20
 **/
public class HttpRequestBuilderV1 extends HttpRequestBuilder {
    public HttpRequestBuilderV1(BaseRequest domain, ServicesContainer servicesContainer) {
        super(domain, servicesContainer);
    }

    @Override
    protected void globalHeaders(Multimap<String, String> headers) {
        headers.put("Accept-Language", servicesContainer.getCommonVariables().getAcceptLanguage());
        headers.put("X-LF-Api-Version", Enums.API_VERSION.V1.version);
        headers.put("X-LF-Signature-Type", Enums.SIGN_TYPE.V1.version);
    }

    @Override
    protected void globalQueryParams(Multimap<String, String> queryParams) {
        queryParams.put("timestamp", domain.getTimestamp());
        queryParams.put("nonce", Integer.toString(domain.getNonce()));
    }

    @Override
    protected void globalBodyMap(Map<String, Object> body) {
        body.put("timestamp", domain.getTimestamp());
        body.put("nonce", domain.getNonce());
    }
}
