package net.linksfield.cube.partnersdk.rest;

import java.io.Closeable;

/**
 * @ClassName HttpRequest
 * @Description Http请求接口定义
 * @Author James.hu
 * @Date 2023/3/16
 **/
public interface HttpFunction extends Closeable {
    /**
     * Get请求
     * 参数使用QueryParams形式
     * @param request
     * @return
     */
    HttpResponse get(HttpRequest request);

    /**
     * Post请求
     * 参数使用Json形式
     * @param request
     * @return
     */
    HttpResponse post(HttpRequest request);

    /**
     * Put请求
     * 参数使用Json形式
     * @param request
     * @return
     */
    HttpResponse put(HttpRequest request);

    /**
     * DELETE请求
     * 参数使用Json形式
     * @param request
     * @return
     */
    HttpResponse delete(HttpRequest request);

}
