package net.linksfield.cube.partnersdk.rest;

import lombok.Getter;
import net.linksfield.cube.partnersdk.configuration.EndpointPropertiesProxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

/**
 * @ClassName EndpointManager
 * @Description 所有的API端口配置管理
 * @Author James.hu
 * @Date 2023/3/15
 **/
public class EndpointManager {
    @Getter
    private EndpointPropertiesProxy propertiesProxy;

    public EndpointManager() {
        this.propertiesProxy = loadEndpointFromProperties();
    }


    /**
     * 从classpath加载对应的API配置文件, 默认情况下读取endpoint-prod.properties
     * 可以通过配置java系统变量 -Dlinksfield.partner.env 调整读取的配置文件
     * 可选系统变量 -Dlinksfield.partner.endpoint.path 自定义读取外部配置文件
     * @return
     */
    public EndpointPropertiesProxy loadEndpointFromProperties() {
        String env = System.getProperty("linksfield.cube.partner.env", "prod");
        String customConfigPath = System.getProperty("linksfield.cube.partner.endpoint.path");
        String filename = Optional.ofNullable(customConfigPath).orElse("endpoint-" + env.toLowerCase() + ".properties");
        EndpointPropertiesProxy properties = new EndpointPropertiesProxy();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filename)) {
            properties.load(inputStream);
            properties.bindingField();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return properties;
    }

}
